# Data Prepare

ScanObjectNN and shapenet_part_seg_hdf5_data we used  from https://github.com/MohamedAfham/CrossPoint



## Data set and source code directory structure

```
modelnet40_c
ScanObjectNN
shapenet_part_seg_hdf5_data
ShapeNetLess
src
```



# Train Self-supervised Model

The code was tested with the following environment: Ubuntu 18.04, python 3.8, pytorch 1.7.1, torchvision 0.8.2，tqdm==4.64.1 and CUDA 11.0

```
#pointnet_cls for pre-training
python PointNet_Contrastive.py

#pointnet_part_seg for pre-training
python PointNet_Part_Contrastive.py

#dgcnn_cls for pre-training
python Dgcnn_Contrastive.py

#dgcnn__part_seg for pre-training
python DgcnnPart_Ctrastive.py

```

# Downstream Tasks

```
#pointnet_cls for ScanObjectNN
python PointNet_Supervise.py --dataset ScanObjectNN

#pointnet_cls for ModelNet40C
python PointNet_Supervise.py --dataset ModelNet40C

#pointnet_part_seg for shapenetpart
python PointNet_Part_Supervise.py

#dgcnn_cls for ScanObjectNN
python Dgcnn_Supervise.py --dataset ScanObjectNN

#dgcnn_cls for ModelNet40C
python Dgcnn_Supervise.py --dataset ModelNet40C

#dgcnn_part_seg for shapenetpart
python Dgcnnpart_Supervise.py
```

